#version 330
#extension GL_EXT_gpu_shader4 : enable
//Colorful BraidsMod01.fsh  by   bitman
//https://www.shadertoy.com/view/4tdczN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float pi = 3.1415926535;
const float tau = 2.*pi;
const float halfpi = pi/2.;
const float pi23 = pi*2./3.;

vec3 hue(float theta){
    return clamp(0.5+sin(vec3(theta+pi23, theta, theta-pi23)), 0., 1.);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float pixel = 6./min(iResolution.x, iResolution.y);
    vec2 uv = pixel * (gl_FragCoord.xy - 0.5*iResolution.xy)-vec2(0.,1.);
    vec2 pol = vec2(length(uv), atan(uv.x*9., uv.y));
    vec3 col = vec3(0.);
    float aa = pixel;
    float t = iTime*tau/3.;
    float pcos = cos(pol.y);
    float w = 0.01/(1.1+pcos);
    float s = 0.01/(1.+pcos);
    float bc = 40.;
    float th = pol.y*bc;
    vec3 bsin = sin(vec3(th, th+pi23, th-pi23)-t);
    vec3 sins = 3.4/(2.+pcos)+bsin/6.;
    vec3 coss = 12.-bsin*bsin*2.; // -sin(x)*sin(x)*2. == -1. + cos(2.*x)
    vec3 dists = vec3(
        distance(pol, vec2(sins.x, pol.y)),
        distance(pol, vec2(sins.y, pol.y)),
        distance(pol, vec2(sins.z, pol.y))
    );
    vec3 braid = smoothstep(w*coss+aa, w*coss-aa, dists)*smoothstep(mix(w,s,smoothstep(-2.5, -1.5, uv.y))*coss-aa, s*coss+aa, dists).yzx;
    vec3 c = hue((pol.y-t/bc)/3.);
    col += mat3(c, c.gbr, c.brg)*braid;
    if (all(equal(col, col.brg))) // mostly gets rid of an artifact at pol.y == pi
        col = vec3(0.);

    gl_FragColor = vec4(col,1.0);
    gl_FragColor.a = length(gl_FragColor.rgb);
}